@props([
'availableSeats' => 0,
'package' => null,
'date' => date('Y-m-d'),
])

{{-- resources/views/components/booking-form.blade.php --}}
<div class="quote-tab">
    <div class="quote-tab__button">
        <ul class="tabs-button-box">
            <li data-tab="#quote1" class="tab-btn-item active-btn-item">
                <div class="quote-tab__button-inner">
                    <h6>@lang('app.book-now')</h6>
                </div>
            </li>
        </ul>
    </div>

    <form id="bookingInformationForm" class="form" action="{{route('booking.session', $package->slug)}}" method="post">
        @csrf
        <div class="tabs-content-box">
            <div class="tab-content-box-item tab-content-box-item-active" id="quote1">
                <p><em>@lang('app.available-seats', ['count' => $availableSeats])</em></p>
                <div class="quote-tab-content-box-item">
                    <div class="search-form">
                        <div class="count">
                            <div class="count-counter">
                                <i class="fa-light fa-user"></i>
                                <div class="count-counter-inner">
                                    <span class="adult_person" id="adult">0</span>
                                    <p class="m-0">@lang('app.adult')</p>
                                </div>
                                <div class="count-counter-inner">
                                    <span class="children" id="children">0</span>
                                    <p class="m-0">@lang('app.child')</p>
                                </div>
                                <div class="count-counter-inner">
                                    <span class="infant" id="infant">0</span>
                                    <p class="m-0">@lang('app.infant')</p>
                                </div>
                            </div>

                            <div class="count-container" style="display: none;">
                                @foreach(['adult' => 'adult-age', 'children' => 'child-age', 'infant' => 'infant-age']
                                as $type => $ageLabel)
                                <div class="count-single">
                                    <div class="count-single-text">
                                        <h6>@lang('app.' . $type)</h6>
                                        <p>@lang('app.' . $ageLabel)</p>
                                    </div>
                                    <div class="count-single-inner">
                                        <button type="button" class="decrement" data-type="{{ $type }}">-</button>
                                        <span class="quantity" id="{{ $type }}-quantity">0</span>
                                        <button type="button" class="increment" data-type="{{ $type }}">+</button>
                                    </div>
                                </div>
                                @endforeach

                                <div class="count-single">
                                    <h5 class="totalPrice">@lang('app.total-price'): </h5>
                                    <h5 class="totalPrice">৳<span id="totalPrice">0</span><span></span></h5>
                                </div>
                                <button type="button" id="bookNowBtn" class="btn-1 w-100">@lang('app.book-now')
                                    <span></span></button>

                            </div>
                            <span id="inputPersonError" class="text-danger" style="display: none;"></span>
                        </div>

                        <input type="hidden" name="adult" id="totalAdult" value="0">
                        <input type="hidden" name="child" id="totalChildren" value="0">
                        <input type="hidden" name="infant" id="totalInfant" value="0">
                        <button type="button" id="bookNowBtn" class="btn-1">@lang('app.book-now') <span></span></button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

@once
@push('script')
<script>
    $(document).ready(function() {
    const config = {
        limit: {{ $availableSeats }},
        prices: {
            adult: {{ $package->adult_price }},
            children: {{ $package->child_price }},
            infant: {{ $package->infant_price }}
        },
        date: '{{ $date }}'
    };

    let quantities = {
        adult: 0,
        children: 0,
        infant: 0
    };

    function updateDisplay(type) {
        $(`#${type}`).text(quantities[type]);
        $(`#${type}-quantity`).text(quantities[type]);
        updateTotalPrice();
    }

    function updateTotalPrice() {
        const totalPrice = Object.entries(quantities).reduce((sum, [type, qty]) => {
            return sum + (qty * config.prices[type]);
        }, 0);

        $('#totalPrice').text(totalPrice.toFixed(2));
    }

    function getTotalPersons() {
        return Object.values(quantities).reduce((sum, qty) => sum + qty, 0);
    }

    $('.increment, .decrement').on('click', function() {
        const type = $(this).data('type');
        const isIncrement = $(this).hasClass('increment');

        if (isIncrement && getTotalPersons() >= config.limit) {
            $('#inputPersonError').text(`Maximum ${config.limit} people allowed.`).show();
            return;
        }

        quantities[type] = Math.max(0, quantities[type] + (isIncrement ? 1 : -1));
        updateDisplay(type);
        $('#inputPersonError').hide();
    });

    $('#bookNowBtn').on('click', function(e) {
        e.preventDefault();

        const totalPerson = getTotalPersons();
        if (totalPerson < 1) {
            $('#inputPersonError').text('Minimum one person required.').show();
            return;
        }

        if (quantities.adult === 0 && (quantities.children > 0 || quantities.infant > 0)) {
            $('#inputPersonError').text('At least one adult person required.').show();
            return;
        }

        // Update hidden inputs
        Object.entries(quantities).forEach(([type, qty]) => {
            $(`#total${type.charAt(0).toUpperCase() + type.slice(1)}`).val(qty);
        });

        $('#bookingInformationForm').submit();
    });
});
</script>
@endpush
@endonce
